#ifndef __TerrainManager_h__
#define __TerrainManager_h__

#include <lib3d/util3d/Vector3d.h>
#include <lib3d/model/modeltypes.h>

#include <list>
#include <vector>
#include <string>
using namespace std;

#define HMAP_SIZE 21

struct tLineEq {
   float m,n;   // line eq: y = mx + n;
};

struct tDecoration {
   int   type;
   float x,y;
   float sx,sy;
   float rz;
   int src_blendmode,dst_blendmode;
   Texture *tex;
};

typedef list<tDecoration> DecorationList;
typedef vector<string>    MapFilesList;

// ----------------------------------------------

class TerrainManager {

public:
   
   void  initWithMesh(tMesh *mesh);
   void  initRandom(float minx=0,float maxx=1,float miny=0,float maxy=1,float hdiff=0.5f,int lod=10);
   void  initFromDirectory();
   void  initFromFile(const char *filename);
   void  initNextMapFromDirectory();
   void  loadDecorations(const char *filename);
   void  setTerrainColor(float basecol[3],float modcol[3]);
   void  setSkyColor(float colup[3],float coldown[3]);
   const char* getMapName() { return mapname; };
   const char* getMapDesc() { return mapdesc; };
   float getHot(float x);
   bool  testCollision(float x,float y);
   void  deform(float x);
   void  setHeight(int x,float h) { hmap[x] = h; };
   void  saveMapToFile(const char *filename);
   const char* getCurrentMapFile();
   
   void  render();
   void  renderMap();
   
   static TerrainManager* instance();

protected:

   void initRandom_recursive(float minx,float maxx,float miny,float maxy,int lod);
   void renderBackground();
   
   tMesh *tmesh;
   Texture *ttex;
   int   curr_face_idx;
   float base_vertex_displacement;
   float height_diff;
   float texscale;
   int   lod;
   float terrain_minx,terrain_maxx;
   float terrain_miny,terrain_maxy;
   float basecol[3],modcol[3];
   float skycolup[3],skycoldown[3];
   char  mapname[256];
   char  mapdesc[256];
   int   curr_map_file;
   float hmap[HMAP_SIZE];

   tLineEq *surfaceEq;
   int surfaceEqCnt;

   DecorationList decorations;
   MapFilesList   mapFiles;

private:
   TerrainManager();
   ~TerrainManager();

};


#endif